package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZineInventoryChangedCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_5258;

@Mixin(class_2066.class_2068.class)
public abstract class InventoryChangedCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineInventoryChangedCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private class_2066.class_2068.class_8948 slots;

    @Shadow @Final @Mutable
    private List<class_2073> items;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setSlots(class_2066.class_2068.class_8948 slots) {
        this.slots = slots;
    }

    @Override
    public void zine$setItems(List<class_2073> items) {
        this.items = items;
    }

    @Override
    public void zine$addItem(class_2073 item) {
        this.items = ZineUtil.addOrUnfreeze(this.items, item);
    }

    @Override
    public void zine$addItems(Collection<class_2073> items) {
        this.items = ZineUtil.addAllOrUnfreeze(this.items, items);
    }
}
