package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZineItemCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZineItemDurabilityChangedCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2069;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_5258;

@Mixin(class_2069.class_2071.class)
public abstract class ItemDurabilityChangedCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineItemCriterionConditions,
        ZineItemDurabilityChangedCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private Optional<class_2073> item;

    @Shadow @Final @Mutable
    private class_2096.class_2100 durability;

    @Shadow @Final @Mutable
    private class_2096.class_2100 delta;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setItem(@Nullable class_2073 item) {
        this.item = Optional.ofNullable(item);
    }

    @Override
    public void zine$setDurability(class_2096.class_2100 durability) {
        this.durability = durability;
    }

    @Override
    public void zine$setDelta(class_2096.class_2100 delta) {
        this.delta = delta;
    }
}
