package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZineDistanceCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZineLevitationCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2025;
import net.minecraft.class_2085;
import net.minecraft.class_2096;
import net.minecraft.class_5258;

@Mixin(class_2085.class_2087.class)
public abstract class LevitationCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineDistanceCriterionConditions,
        ZineLevitationCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private Optional<class_2025> distance;

    @Shadow @Final @Mutable
    private class_2096.class_2100 duration;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setDistance(@Nullable class_2025 distance) {
        this.distance = Optional.ofNullable(distance);
    }

    @Override
    public void zine$setDuration(class_2096.class_2100 duration) {
        this.duration = duration;
    }
}
