package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZineEntityCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZineItemCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2073;
import net.minecraft.class_5258;
import net.minecraft.class_5409;

@Mixin(class_5409.class_5410.class)
public abstract class PlayerInteractedWithEntityCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineItemCriterionConditions,
        ZineEntityCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private Optional<class_2073> item;

    @Shadow @Final @Mutable
    private Optional<class_5258> entity;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setItem(@Nullable class_2073 item) {
        this.item = Optional.ofNullable(item);
    }

    @Override
    public void zine$setEntity(@Nullable class_5258 entity) {
        this.entity = Optional.ofNullable(entity);
    }
}
