package com.eightsidedsquare.zine.mixin.client.font;

import com.eightsidedsquare.zine.core.ZineCustomStyleAttributes;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_9848;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_327.class_5232.class)
public abstract class TextRendererDrawerMixin {

    @Shadow @Final
    class_327 field_24240;
    @Shadow
    float x;
    @Shadow
    float y;
    @Shadow @Final @Mutable
    private int color;

    @SuppressWarnings("ConstantValue")
    @Inject(method = "accept(ILnet/minecraft/text/Style;I)Z", at = @At("HEAD"))
    private void zine$acceptOutline(int index, class_2583 style, int codePoint, CallbackInfoReturnable<Boolean> cir) {
        Integer outlineColor = style.zine$getCustomAttribute(ZineCustomStyleAttributes.OUTLINE);
        if(outlineColor != null) {
            float originalX = this.x;
            float originalY = this.y;
            int originalColor = this.color;
            float alpha = class_9848.method_65100(originalColor) * class_9848.method_65100(outlineColor);
            this.color = class_9848.method_71346(alpha, originalColor);
            for (int x = -1; x <= 1; x++) {
                for (int y = -1; y <= 1; y++) {
                    if (x != 0 || y != 0) {
                        float[] advance = new float[]{originalX};
                        ((TextRendererAccessor) this.field_24240).zine$invokeAcceptOutline(
                                (class_327.class_5232) (Object) this,
                                advance,
                                x,
                                originalY,
                                y,
                                outlineColor,
                                index,
                                style,
                                codePoint
                        );
                    }
                }
            }
            this.x = originalX;
            this.y = originalY;
            this.color = originalColor;
        }
    }

    @ModifyReturnValue(method = "getShadowColor", at = @At("RETURN"))
    private int zine$getShadowColor(int original, class_2583 style, int textColor) {
        if(original != 0 && style.zine$containsCustomAttribute(ZineCustomStyleAttributes.OUTLINE)) {
            return 0;
        }
        return original;
    }
}
