package com.eightsidedsquare.zine.mixin.client.item;

import com.eightsidedsquare.zine.client.item.ZineSelectItemModelUnbakedSwitch;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import net.minecraft.class_10451;
import net.minecraft.class_10494;

@Mixin(class_10451.class_10454.class)
public abstract class SelectItemModelUnbakedSwitchMixin<P extends class_10494<T>, T> implements ZineSelectItemModelUnbakedSwitch<P, T> {

    @Shadow @Final @Mutable
    private P property;

    @Shadow @Final @Mutable private List<class_10451.class_10452<T>> cases;

    @Override
    public void zine$setProperty(P property) {
        this.property = property;
    }

    @Override
    public void zine$setCases(List<class_10451.class_10452<T>> cases) {
        this.cases = cases;
    }

    @Override
    public void zine$addCases(List<class_10451.class_10452<T>> cases) {
        this.cases = ZineUtil.addAllOrUnfreeze(this.cases, cases);
    }

    @Override
    public void zine$addCase(class_10451.class_10452<T> switchCase) {
        this.cases = ZineUtil.addOrUnfreeze(this.cases, switchCase);
    }
}
