package com.eightsidedsquare.zine.mixin.client.item;

import com.eightsidedsquare.zine.client.item.ZineUnbakedRangeDispatchItemModel;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_10439;
import net.minecraft.class_10448;
import net.minecraft.class_1800;

@Mixin(class_10448.class_10450.class)
public abstract class UnbakedRangeDispatchItemModelMixin implements ZineUnbakedRangeDispatchItemModel {

    @Shadow @Final @Mutable
    private class_1800 property;
    @Shadow @Final @Mutable
    private float scale;
    @Shadow @Final @Mutable
    private List<class_10448.class_10449> entries;
    @Shadow @Final @Mutable
    private Optional<class_10439.class_10441> fallback;

    @Override
    public void zine$setProperty(class_1800 property) {
        this.property = property;
    }

    @Override
    public void zine$setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public void zine$setFallback(@Nullable class_10439.class_10441 fallback) {
        this.fallback = Optional.ofNullable(fallback);
    }

    @Override
    public void zine$addEntry(class_10448.class_10449 entry) {
        this.entries = ZineUtil.addOrUnfreeze(this.entries, entry);
    }

    @Override
    public void zine$addEntries(List<class_10448.class_10449> entries) {
        this.entries = ZineUtil.addAllOrUnfreeze(this.entries, entries);
    }
}
