package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineBlockPredicate;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_2105;
import net.minecraft.class_2248;
import net.minecraft.class_4550;
import net.minecraft.class_4559;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

@Mixin(class_4550.class)
public abstract class BlockPredicateMixin implements ZineBlockPredicate {

    @Shadow @Final @Mutable
    private Optional<class_6885<class_2248>> blocks;

    @Shadow @Final @Mutable
    private Optional<class_4559> state;

    @Shadow @Final @Mutable
    private Optional<class_2105> nbt;

    @Override
    public void zine$setBlocks(@Nullable class_6885<class_2248> blocks) {
        this.blocks = Optional.ofNullable(blocks);
    }

    @Override
    public void zine$addBlock(class_2248 block) {
        if(this.blocks.isPresent()) {
            this.blocks = Optional.of(ZineUtil.mergeValue(this.blocks.get(), class_7923.field_41175::method_47983, block));
            return;
        }
        this.blocks = Optional.of(class_6885.method_40245(class_7923.field_41175::method_47983, block));
    }

    @Override
    public void zine$addBlocks(Collection<class_2248> blocks) {
        if(this.blocks.isPresent()) {
            this.blocks = Optional.of(ZineUtil.mergeValues(this.blocks.get(), class_7923.field_41175::method_47983, blocks));
            return;
        }
        this.blocks = Optional.of(class_6885.method_40244(class_7923.field_41175::method_47983, blocks));
    }

    @Override
    public void zine$setState(@Nullable class_4559 state) {
        this.state = Optional.ofNullable(state);
    }

    @Override
    public void zine$setNbt(@Nullable class_2105 nbt) {
        this.nbt = Optional.ofNullable(nbt);
    }
}
