package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineComponentsPredicate;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Map;
import net.minecraft.class_10914;
import net.minecraft.class_9329;
import net.minecraft.class_9360;

@Mixin(class_10914.class)
public abstract class ComponentsPredicateMixin implements ZineComponentsPredicate {

    @Shadow @Final @Mutable
    private class_9329 exact;

    @Shadow @Final @Mutable
    private Map<class_9360.class_8745<?>, class_9360> partial;

    @Override
    public void zine$setExact(class_9329 exact) {
        this.exact = exact;
    }

    @Override
    public void zine$setPartial(Map<class_9360.class_8745<?>, class_9360> partial) {
        this.partial = partial;
    }

    @Override
    public void zine$addPartial(class_9360.class_8745<?> type, class_9360 predicate) {
        this.partial = ZineUtil.putOrUnfreeze(this.partial, type, predicate);
    }
}
