package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineDamageSourcePredicate;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_8110;
import net.minecraft.class_8129;

@Mixin(class_2022.class)
public abstract class DamageSourcePredicateMixin implements ZineDamageSourcePredicate {

    @Shadow @Final @Mutable
    private List<class_8129<class_8110>> tags;

    @Shadow @Final @Mutable
    private Optional<class_2048> sourceEntity;

    @Shadow @Final @Mutable
    private Optional<class_2048> directEntity;

    @Shadow @Final @Mutable
    private Optional<Boolean> isDirect;

    @Override
    public void zine$setTags(List<class_8129<class_8110>> tags) {
        this.tags = tags;
    }

    @Override
    public void zine$addTag(class_8129<class_8110> tag) {
        this.tags = ZineUtil.addOrUnfreeze(this.tags, tag);
    }

    @Override
    public void zine$addTags(List<class_8129<class_8110>> tags) {
        this.tags = ZineUtil.addAllOrUnfreeze(this.tags, tags);
    }

    @Override
    public void zine$setDirectEntity(@Nullable class_2048 directEntity) {
        this.directEntity = Optional.ofNullable(directEntity);
    }

    @Override
    public void zine$setSourceEntity(@Nullable class_2048 sourceEntity) {
        this.sourceEntity = Optional.ofNullable(sourceEntity);
    }

    @Override
    public void zine$setDirect(@Nullable Boolean direct) {
        this.isDirect = Optional.ofNullable(direct);
    }
}
