package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineItemPredicate;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_10914;
import net.minecraft.class_1792;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

@Mixin(class_2073.class)
public abstract class ItemPredicateMixin implements ZineItemPredicate {

    @Shadow @Final @Mutable
    private Optional<class_6885<class_1792>> items;

    @Shadow @Final @Mutable
    private class_2096.class_2100 count;

    @Shadow @Final @Mutable
    private class_10914 components;

    @Override
    public void zine$setItems(@Nullable class_6885<class_1792> items) {
        this.items = Optional.ofNullable(items);
    }

    @Override
    public void zine$addItem(class_1792 item) {
        if(this.items.isPresent()) {
            this.items = Optional.of(ZineUtil.mergeValue(this.items.get(), class_7923.field_41178::method_47983, item));
            return;
        }
        this.items = Optional.of(class_6885.method_40245(class_7923.field_41178::method_47983, item));
    }

    @Override
    public void zine$addItems(Collection<class_1792> items) {
        if(this.items.isPresent()) {
            this.items = Optional.of(ZineUtil.mergeValues(this.items.get(), class_7923.field_41178::method_47983, items));
            return;
        }
        this.items = Optional.of(class_6885.method_40244(class_7923.field_41178::method_47983, items));
    }

    @Override
    public void zine$setCount(class_2096.class_2100 count) {
        this.count = count;
    }

    @Override
    public void zine$setComponents(class_10914 components) {
        this.components = components;
    }
}
