package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineLootContextPredicate;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_5341;

@Mixin(class_5258.class)
public abstract class LootContextPredicateMixin implements ZineLootContextPredicate {

    @Shadow @Final @Mutable
    private List<class_5341> conditions;

    @Shadow @Final @Mutable
    private Predicate<class_47> combinedCondition;

    @Override
    public List<class_5341> zine$getConditions() {
        return this.conditions;
    }

    @Override
    public void zine$setConditions(List<class_5341> conditions) {
        this.conditions = conditions;
        this.combinedCondition = class_156.method_56613(conditions);
    }

    @Override
    public void zine$addCondition(class_5341 condition) {
        this.conditions = ZineUtil.addOrUnfreeze(this.conditions, condition);
        this.combinedCondition = class_156.method_56613(this.conditions);
    }

    @Override
    public void zine$addConditions(List<class_5341> conditions) {
        this.conditions = ZineUtil.addAllOrUnfreeze(this.conditions, conditions);
        this.combinedCondition = class_156.method_56613(this.conditions);
    }
}
