package com.eightsidedsquare.zine.client.atlas;

import com.mojang.logging.LogUtils;
import org.slf4j.Logger;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7948;
import net.minecraft.class_8066;

public final class AtlasSourceUtil {
    private AtlasSourceUtil() {
    }

    private static final Logger LOGGER = LogUtils.getLogger();

    public static class_8066 createPaletted(List<class_2960> textures, class_2960 paletteKey, Map<String, class_2960> permutations) {
        return new class_8066(textures, paletteKey, permutations);
    }

    public static TextureData open(class_3300 resourceManager, class_2960 texture) {
        Optional<class_3298> optional = resourceManager.method_14486(class_7948.field_42075.method_45112(texture));
        if(optional.isEmpty()) {
            LOGGER.error("Failed to load texture {}", texture);
            throw new IllegalArgumentException();
        }
        try {
            InputStream inputStream = optional.get().method_14482();

            TextureData textureData;
            try (class_1011 nativeImage = class_1011.method_4309(inputStream)) {
                textureData = new TextureData(nativeImage.method_61942(), nativeImage.method_4307(), nativeImage.method_4323());
            } catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    } catch (Throwable suppressedThrowable) {
                        throwable.addSuppressed(suppressedThrowable);
                    }
                }
                throw throwable;
            }
            inputStream.close();
            return textureData;
        } catch (Exception e) {
            LOGGER.error("Couldn't load texture {}", texture, e);
            throw new IllegalArgumentException();
        }
    }

    public static class_1011 createNativeImage(int width, int height, ImagePos2Color function) {
        class_1011 nativeImage = new class_1011(width, height, false);
        int size = width * height;
        for(int i = 0; i < size; i++) {
            int x = i % width;
            int y = i / width;
            float u = x / (float) width;
            float v = y / (float) height;
            nativeImage.method_61941(x, y, function.apply(i, x, y, u, v));
        }
        return nativeImage;
    }

    public static class_1011 createAnimatedNativeImage(int frames, int width, int height, AnimatedImagePos2Color function) {
        class_1011 nativeImage = new class_1011(width, height * frames, false);
        int size = width * height;
        for(int i = 0; i < size; i++) {
            int x = i % width;
            int y = i / width;
            float u = x / (float) width;
            float v = y / (float) height;
            for(int frame = 0; frame < frames; frame++) {
                nativeImage.method_61941(x, y + frame * height, function.apply(frame, i, x, y, u, v));
            }
        }
        return nativeImage;
    }

    @FunctionalInterface
    public interface ImagePos2Color {
        int apply(int index, int x, int y, float u, float v);
    }

    @FunctionalInterface
    public interface AnimatedImagePos2Color {
        int apply(int frame, int index, int x, int y, float u, float v);
    }

}
