package com.eightsidedsquare.zine.client.atlas;

import com.eightsidedsquare.zine.client.util.ConnectedPattern;
import com.eightsidedsquare.zine.client.util.ConnectedShape;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import net.minecraft.class_7948;
import org.slf4j.Logger;

import java.util.EnumMap;
import java.util.Optional;

@Environment(EnvType.CLIENT)
public class ConnectedTexturesAtlasSource implements class_7948 {

    public static final MapCodec<ConnectedTexturesAtlasSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_2960.field_25139.fieldOf("base_name").forGetter(ConnectedTexturesAtlasSource::getBaseName),
            class_2960.field_25139.optionalFieldOf("all").forGetter(source -> Optional.of(source.allTexture)),
            class_2960.field_25139.optionalFieldOf("corners").forGetter(source -> Optional.of(source.cornersTexture)),
            class_2960.field_25139.optionalFieldOf("horizontal").forGetter(source -> Optional.of(source.horizontalTexture)),
            class_2960.field_25139.optionalFieldOf("none").forGetter(source -> Optional.of(source.noneTexture)),
            class_2960.field_25139.optionalFieldOf("vertical").forGetter(source -> Optional.of(source.verticalTexture))
    ).apply(instance, ConnectedTexturesAtlasSource::new));

    private static final Logger LOGGER = LogUtils.getLogger();

    private class_2960 baseName;
    private class_2960 allTexture;
    private class_2960 cornersTexture;
    private class_2960 horizontalTexture;
    private class_2960 noneTexture;
    private class_2960 verticalTexture;

    public ConnectedTexturesAtlasSource(class_2960 baseName,
                                        class_2960 allTexture,
                                        class_2960 cornersTexture,
                                        class_2960 horizontalTexture,
                                        class_2960 noneTexture,
                                        class_2960 verticalTexture) {
        this.baseName = baseName;
        this.allTexture = allTexture;
        this.cornersTexture = cornersTexture;
        this.horizontalTexture = horizontalTexture;
        this.noneTexture = noneTexture;
        this.verticalTexture = verticalTexture;
    }

    public ConnectedTexturesAtlasSource(class_2960 baseName,
                                        Optional<class_2960> allTexture,
                                        Optional<class_2960> cornersTexture,
                                        Optional<class_2960> horizontalTexture,
                                        Optional<class_2960> noneTexture,
                                        Optional<class_2960> verticalTexture) {
        this(
                baseName,
                allTexture.orElseGet(() -> baseName.method_48331("_all")),
                cornersTexture.orElseGet(() -> baseName.method_48331("_corners")),
                horizontalTexture.orElseGet(() -> baseName.method_48331("_horizontal")),
                noneTexture.orElseGet(() -> baseName.method_48331("_none")),
                verticalTexture.orElseGet(() -> baseName.method_48331("_vertical"))
        );
    }

    public ConnectedTexturesAtlasSource(class_2960 baseName) {
        this(
                baseName,
                Optional.empty(),
                Optional.empty(),
                Optional.empty(),
                Optional.empty(),
                Optional.empty()
        );
    }

    @Override
    public MapCodec<? extends class_7948> method_67288() {
        return CODEC;
    }

    public class_2960 getBaseName() {
        return this.baseName;
    }

    public void setBaseName(class_2960 baseName) {
        this.baseName = baseName;
    }

    public class_2960 getAllTexture() {
        return this.allTexture;
    }

    public void setAllTexture(class_2960 allTexture) {
        this.allTexture = allTexture;
    }

    public class_2960 getCornersTexture() {
        return this.cornersTexture;
    }

    public void setCornersTexture(class_2960 cornersTexture) {
        this.cornersTexture = cornersTexture;
    }

    public class_2960 getHorizontalTexture() {
        return this.horizontalTexture;
    }

    public void setHorizontalTexture(class_2960 horizontalTexture) {
        this.horizontalTexture = horizontalTexture;
    }

    public class_2960 getNoneTexture() {
        return this.noneTexture;
    }

    public void setNoneTexture(class_2960 noneTexture) {
        this.noneTexture = noneTexture;
    }

    public class_2960 getVerticalTexture() {
        return this.verticalTexture;
    }

    public void setVerticalTexture(class_2960 verticalTexture) {
        this.verticalTexture = verticalTexture;
    }

    public class_2960 getTexture(ConnectedShape shape) {
        return switch (shape) {
            case ALL -> this.getAllTexture();
            case CORNER -> this.getCornersTexture();
            case HORIZONTAL -> this.getHorizontalTexture();
            case NONE -> this.getNoneTexture();
            case VERTICAL -> this.getVerticalTexture();
        };
    }

    @Override
    public void method_47673(class_3300 resourceManager, class_7949 regions) {
        EnumMap<ConnectedShape, TextureData> data = new EnumMap<>(ConnectedShape.class);
        int dataSize = -1;
        for(ConnectedShape shape : ConnectedShape.values()) {
            TextureData textureData = AtlasSourceUtil.open(resourceManager, this.getTexture(shape));
            int size = textureData.data().length;
            if(dataSize == -1) {
                dataSize = size;
            }else if(size != dataSize) {
                LOGGER.warn("Textures have different sizes: {} and {}", dataSize, size);
                throw new IllegalArgumentException();
            }
            data.put(shape, textureData);
        }
        class_7771 dimensions = data.get(ConnectedShape.ALL).getDimensions();
        int width = dimensions.comp_1049();
        int height = dimensions.comp_1050();
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        for(ConnectedPattern pattern : ConnectedPattern.values()) {
            if(pattern.allMatch()) {
                continue;
            }
            TextureData nw = data.get(pattern.getNW());
            TextureData ne = data.get(pattern.getNE());
            TextureData se = data.get(pattern.getSE());
            TextureData sw = data.get(pattern.getSW());
            class_2960 texture = pattern.addSuffix(this.getBaseName());
            regions.method_47670(texture, spriteOpener -> {
                class_1011 nativeImage = AtlasSourceUtil.createNativeImage(width, height, (index, x, y, u, v) ->
                        (x >= halfWidth ? (y >= halfHeight ? se : ne) : (y >= halfHeight ? sw : nw)).data()[index]
                );
                return new class_7764(texture, dimensions, nativeImage);
            });
        }
    }
}
