package com.eightsidedsquare.zine.client.atlas;

import com.eightsidedsquare.zine.client.atlas.generator.SpriteGenerator;
import com.eightsidedsquare.zine.client.atlas.generator.SpriteProperties;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7948;

public class GeneratorAtlasSource implements class_7948 {

    public static final MapCodec<GeneratorAtlasSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            SpriteGenerator.CODEC.fieldOf("sprite_generator").forGetter(GeneratorAtlasSource::getSpriteGenerator),
            class_2960.field_25139.fieldOf("output_id").forGetter(GeneratorAtlasSource::getOutputId),
            SpriteProperties.CODEC.optionalFieldOf("properties", SpriteProperties.DEFAULT).forGetter(GeneratorAtlasSource::getProperties)
    ).apply(instance, GeneratorAtlasSource::new));

    private SpriteGenerator spriteGenerator;
    private class_2960 outputId;
    private SpriteProperties properties;

    public GeneratorAtlasSource(SpriteGenerator spriteGenerator, class_2960 outputId, SpriteProperties properties) {
        this.spriteGenerator = spriteGenerator;
        this.outputId = outputId;
        this.properties = properties;
    }

    public GeneratorAtlasSource(SpriteGenerator spriteGenerator, class_2960 outputId, int width, int height) {
        this(spriteGenerator, outputId, new SpriteProperties(width, height));
    }

    public GeneratorAtlasSource(SpriteGenerator spriteGenerator, class_2960 outputId) {
        this(spriteGenerator, outputId, SpriteProperties.DEFAULT);
    }

    @Override
    public MapCodec<? extends class_7948> method_67288() {
        return CODEC;
    }

    public SpriteGenerator getSpriteGenerator() {
        return this.spriteGenerator;
    }

    public void setSpriteGenerator(SpriteGenerator spriteGenerator) {
        this.spriteGenerator = spriteGenerator;
    }

    public class_2960 getOutputId() {
        return this.outputId;
    }

    public void setOutputId(class_2960 outputId) {
        this.outputId = outputId;
    }

    public SpriteProperties getProperties() {
        return this.properties;
    }

    public void setProperties(SpriteProperties dimensions) {
        this.properties = dimensions;
    }

    @Override
    public void method_47673(class_3300 resourceManager, class_7949 regions) {
        Output output = this.spriteGenerator.generate(this.outputId, this.properties);
        regions.method_47670(this.outputId, spriteOpener -> {
            int width = this.properties.width();
            int height = this.properties.height();
            int frames = this.properties.frames();
            class_1011 nativeImage = new class_1011(width, height * frames, false);
            for(int frame = 0; frame < frames; frame++) {
                float w = frame / (float) frames;
                for(int y = 0; y < height; y++) {
                    float v = y / (float) height;
                    for(int x = 0; x < width; x++) {
                        float u = x / (float) width;
                        nativeImage.method_61941(x, y + frame * height, output.apply(u, v, w));
                    }
                }
            }
            return this.properties.createContents(this.outputId, nativeImage);
        });
    }

    @FunctionalInterface
    public interface Output {
        int apply(float u, float v, float w);
    }
}
