package com.eightsidedsquare.zine.client.atlas.generator;

import com.eightsidedsquare.zine.client.atlas.GeneratorAtlasSource;
import com.eightsidedsquare.zine.client.atlas.gradient.Gradient;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5216;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import org.joml.Vector2f;
import org.joml.Vector3f;

public record NoiseSpriteGenerator(Gradient gradient,
                                   class_5216.class_5487 parameters,
                                   long seed,
                                   Vector2f scale,
                                   Vector3f velocity,
                                   float blendMargin) implements SpriteGenerator {

    public static final MapCodec<NoiseSpriteGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            Gradient.CODEC.fieldOf("gradient").forGetter(NoiseSpriteGenerator::gradient),
            class_5216.class_5487.field_35424.fieldOf("parameters").forGetter(NoiseSpriteGenerator::parameters),
            Codec.LONG.optionalFieldOf("seed", 0L).forGetter(NoiseSpriteGenerator::seed),
            class_5699.field_59993.optionalFieldOf("scale", new Vector2f(1, 1)).forGetter(NoiseSpriteGenerator::scale),
            class_5699.field_40723.optionalFieldOf("velocity", new Vector3f(0, 0, 1)).forGetter(NoiseSpriteGenerator::velocity),
            Codec.floatRange(0, 0.5f).optionalFieldOf("blend_margin", 0f).forGetter(NoiseSpriteGenerator::blendMargin)

    ).apply(instance, NoiseSpriteGenerator::new));

    @Override
    public MapCodec<? extends SpriteGenerator> getCodec() {
        return CODEC;
    }

    @Override
    public GeneratorAtlasSource.Output generate(class_2960 outputId, SpriteProperties properties) {
        class_5216 sampler = class_5216.method_38476(class_5819.method_43049(this.seed), this.parameters);
        if(this.blendMargin == 0) {
            return (u, v, w) -> this.gradient.get(this.value(sampler, u, v, w), 0, w);
        }
        return (u, v, w) -> this.gradient.get(this.valueUVW(sampler, u, v, w), 0, w);
    }

    private float valueU(class_5216 sampler, float u, float v, float w) {
        float blend = this.blendFac(u);
        float a = this.value(sampler, u, v, w);
        if(blend == 0) {
            return a;
        }
        float b = this.value(sampler, 1 - u, v, w);
        return class_3532.method_16439(blend, a, b);
    }

    private float valueUV(class_5216 sampler, float u, float v, float w) {
        float blend = this.blendFac(v);
        float a = this.valueU(sampler, u, v, w);
        if(blend == 0) {
            return a;
        }
        float b = this.valueU(sampler, u, 1 - v, w);
        return class_3532.method_16439(blend, a, b);
    }

    private float valueUVW(class_5216 sampler, float u, float v, float w) {
        float blend = this.blendFac(w);
        float a = this.valueUV(sampler, u, v, w);
        if(blend == 0) {
            return a;
        }
        float b = this.valueUV(sampler, u, v, 1 - w);
        return class_3532.method_16439(blend, a, b);
    }

    private float value(class_5216 sampler, float u, float v, float w) {
        double value = sampler.method_27406(u * this.scale.x + this.velocity.x * w, v * this.scale.y + this.velocity.y * w, this.velocity.z * w);
        return (float) (value + 1) * 0.5f;
    }

    private float blendFac(float x) {
        float r = 1f / (2f * this.blendMargin);
        return (1 - class_3532.method_15362(class_3532.field_29844 * Math.max(0, Math.abs(1 - 2 * x) * r - r + 1f))) * 0.25f;
    }
}
