package com.eightsidedsquare.zine.client.atlas.generator;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_7368;
import net.minecraft.class_7677;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import java.util.List;
import java.util.Optional;

@Environment(EnvType.CLIENT)
public record SpriteProperties(int width, int height, int frames, int frameTime, boolean interpolate) {

    public static final SpriteProperties DEFAULT = new SpriteProperties(16, 16);
    public static final Codec<SpriteProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_5699.field_33442.fieldOf("width").forGetter(SpriteProperties::width),
            class_5699.field_33442.fieldOf("height").forGetter(SpriteProperties::height),
            class_5699.field_33441.optionalFieldOf("frames", 0).forGetter(SpriteProperties::frames),
            class_5699.field_33442.optionalFieldOf("frame_time", 1).forGetter(SpriteProperties::frameTime),
            Codec.BOOL.optionalFieldOf("interpolate", false).forGetter(SpriteProperties::interpolate)
    ).apply(instance, SpriteProperties::new));

    public SpriteProperties(int width, int height, int frames, int frameTime) {
        this(width, height, frames, frameTime, false);
    }

    public SpriteProperties(int width, int height, int frames) {
        this(width, height, frames, 1);
    }

    public SpriteProperties(int width, int height) {
        this(width, height, 0);
    }

    public class_7771 getDimensions() {
        return new class_7771(this.width, this.height);
    }

    public class_1079 getAnimationResourceMetadata() {
        return new class_1079(
                Optional.empty(),
                Optional.empty(),
                Optional.empty(),
                this.frameTime,
                this.interpolate
        );
    }

    public class_7764 createContents(class_2960 id, class_1011 nativeImage) {
        return new class_7764(id, this.getDimensions(), nativeImage, Optional.of(this.getAnimationResourceMetadata()), List.of());
    }

    private class_7368 resourceMetadata(class_1079 animationMetadata) {
        return new class_7368() {
            @SuppressWarnings("unchecked")
            @Override
            public <T> Optional<T> method_43041(class_7677<T> serializer) {
                if(serializer.equals(class_1079.field_55537)) {
                    return (Optional<T>) Optional.of(animationMetadata);
                }
                return Optional.empty();
            }
        };
    }

}
