package com.eightsidedsquare.zine.client.block;

import net.fabricmc.fabric.api.client.model.loading.v1.CompositeBlockStateModel;
import net.minecraft.class_1087;
import net.minecraft.class_10893;
import net.minecraft.class_1097;
import net.minecraft.class_2960;
import net.minecraft.class_6012;
import net.minecraft.class_813;
import java.util.List;

public final class BlockStateModels {

    /**
     * Creates a {@link class_10893.class_10894} for the given model variant
     */
    public static class_10893.class_10894 simple(class_813 variant) {
        return new class_10893.class_10894(variant);
    }

    /**
     * Creates a {@link class_10893.class_10894} for the given model identifier
     */
    public static class_10893.class_10894 simple(class_2960 modelId) {
        return simple(new class_813(modelId));
    }

    /**
     * Creates a {@link class_1097.class_10898} for the given unbaked block state model pool
     */
    public static class_1097.class_10898 weighted(class_6012<class_1087.class_10892> entries) {
        return new class_1097.class_10898(entries);
    }

    /**
     * Creates a {@link class_1097.class_10898} for the given unbaked block state model pool builder
     */
    public static class_1097.class_10898 weighted(class_6012.class_6006<class_1087.class_10892> entriesBuilder) {
        return weighted(entriesBuilder.method_34974());
    }

    /**
     * Creates a {@link class_1097.class_10898} for the given unbaked block state models
     */
    public static class_1097.class_10898 weighted(class_1087.class_10892... models) {
        class_6012.class_6006<class_1087.class_10892> entriesBuilder = class_6012.method_66215();
        for (class_1087.class_10892 model : models) {
            entriesBuilder.method_54453(model);
        }
        return weighted(entriesBuilder);
    }

    /**
     * Creates a {@link CompositeBlockStateModel.Unbaked} for the given unbaked block state models
     */
    public static CompositeBlockStateModel.Unbaked composite(List<class_1087.class_10892> models) {
        return CompositeBlockStateModel.Unbaked.of(models);
    }

    /**
     * Creates a {@link CompositeBlockStateModel.Unbaked} for the given unbaked block state models
     */
    public static CompositeBlockStateModel.Unbaked composite(class_1087.class_10892... models) {
        return composite(List.of(models));
    }

    /**
     * Creates a {@link ConnectedBlockStateModel.Unbaked}
     * @param baseTexture texture id base for the model's connected pattern textures
     * @param fancy {@code true} for adding edges based on blocks in front of a face
     */
    public static ConnectedBlockStateModel.Unbaked connected(class_2960 baseTexture, boolean fancy) {
        return new ConnectedBlockStateModel.Unbaked(baseTexture, fancy);
    }

    /**
     * Creates a {@link TessellatingBlockStateModel.Unbaked}
     * @param texture id of the texture
     * @param particleTexture id of the particle texture
     * @param size the number of blocks that the texture tessellates across
     */
    public static TessellatingBlockStateModel.Unbaked tessellating(class_2960 texture, class_2960 particleTexture, int size) {
        return new TessellatingBlockStateModel.Unbaked(texture, particleTexture, size);
    }

    /**
     * Creates a {@link TessellatingBlockStateModel.Unbaked}
     * @param texture id of the texture
     * @param size the number of blocks that the texture tessellates across
     */
    public static TessellatingBlockStateModel.Unbaked tessellating(class_2960 texture, int size) {
        return new TessellatingBlockStateModel.Unbaked(texture, size);
    }

    private BlockStateModels() {
    }

}
