package com.eightsidedsquare.zine.client.data;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.class_1087;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4934;
import net.minecraft.class_790;

public class CustomVariantsBlockModelDefinitionCreator implements class_4917 {

    private final class_2248 block;
    private final Map<class_4934, class_1087.class_10892> variants;
    private final Set<class_2769<?>> definedProperties;

    private CustomVariantsBlockModelDefinitionCreator(class_2248 block, Map<class_4934, class_1087.class_10892> variants, Set<class_2769<?>> definedProperties) {
        this.block = block;
        this.variants = variants;
        this.definedProperties = definedProperties;
    }

    public CustomVariantsBlockModelDefinitionCreator coordinate(class_4926<UnaryOperator<class_1087.class_10892>> operatorMap) {
        Set<class_2769<?>> properties = class_4925.method_67858(this.definedProperties, this.block, operatorMap);
        ImmutableMap.Builder<class_4934, class_1087.class_10892> builder = ImmutableMap.builder();
        for (Map.Entry<class_4934, class_1087.class_10892> entry : this.variants.entrySet()) {
            for (Map.Entry<class_4934, UnaryOperator<class_1087.class_10892>> operatorEntry : operatorMap.method_25782().entrySet()) {
                builder.put(entry.getKey().method_25820(operatorEntry.getKey()), operatorEntry.getValue().apply(entry.getValue()));
            }
        }
        return new CustomVariantsBlockModelDefinitionCreator(this.block, builder.build(), properties);
    }

    public CustomVariantsBlockModelDefinitionCreator apply(UnaryOperator<class_1087.class_10892> operator) {
        ImmutableMap.Builder<class_4934, class_1087.class_10892> builder = ImmutableMap.builder();
        for (Map.Entry<class_4934, class_1087.class_10892> entry : this.variants.entrySet()) {
            builder.put(entry.getKey(), operator.apply(entry.getValue()));
        }
        return new CustomVariantsBlockModelDefinitionCreator(this.block, builder.build(), this.definedProperties);
    }

    public static CustomVariantsBlockModelDefinitionCreator.Empty create(class_2248 block) {
        return new CustomVariantsBlockModelDefinitionCreator.Empty(block);
    }

    public static CustomVariantsBlockModelDefinitionCreator create(class_2248 block, class_4926<class_1087.class_10892> map) {
        Set<class_2769<?>> properties = class_4925.method_67858(Set.of(), block, map);
        return new CustomVariantsBlockModelDefinitionCreator(block, map.method_25782(), properties);
    }

    public static CustomVariantsBlockModelDefinitionCreator create(class_2248 block, class_1087.class_10892 model) {
        return new CustomVariantsBlockModelDefinitionCreator(block, Map.of(class_4934.field_22881, model), Set.of());
    }

    @Override
    public class_2248 method_25743() {
        return this.block;
    }

    @Override
    public class_790 method_67844() {
        Map<String, class_1087.class_10892> models = new HashMap<>();
        for (Map.Entry<class_4934, class_1087.class_10892> entry : this.variants.entrySet()) {
            models.put(entry.getKey().method_25822(), entry.getValue());
        }
        return new class_790(Optional.of(new class_790.class_10888(models)), Optional.empty());
    }

    public static class Empty {
        private final class_2248 block;

        Empty(class_2248 block) {
            this.block = block;
        }

        public CustomVariantsBlockModelDefinitionCreator with(class_4926<class_1087.class_10892> map) {
            return CustomVariantsBlockModelDefinitionCreator.create(this.block, map);
        }

        public CustomVariantsBlockModelDefinitionCreator with(class_1087.class_10892 model) {
            return CustomVariantsBlockModelDefinitionCreator.create(this.block, model);
        }

    }
}
