package com.eightsidedsquare.zine.client.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_10439;
import net.minecraft.class_2960;

@Environment(EnvType.CLIENT)
public final class ItemModelEvents {
    private ItemModelEvents() {
    }

    /**
     * Event to replace or modify unbaked item models before they are baked.
     */
    public static final Event<BeforeBake> BEFORE_BAKE = EventFactory.createArrayBacked(BeforeBake.class, callbacks -> (id, unbaked) -> {
        for(BeforeBake callback : callbacks) {
            unbaked = callback.modifyBeforeBake(id, unbaked);
        }
        return unbaked;
    });

    /**
     * Event to dynamically add unbaked item models to the game, in a similar manner to data generation.
     */
    public static final Event<AddUnbaked> ADD_UNBAKED = EventFactory.createArrayBacked(AddUnbaked.class, callbacks -> consumer -> {
        for(AddUnbaked callback : callbacks) {
            callback.addUnbakedModels(consumer);
        }
    });

    @FunctionalInterface
    public interface BeforeBake {
        /**
         * Called to modify unbaked item models. Return {@code unbaked} if no modification is meant to take place.
         * <p>{@code id} may directly correlate to the id of an {@link net.minecraft.class_1792} in {@link net.minecraft.class_7923#field_41178}.
         * @param id the id of the unbaked item model
         * @param unbaked the unbaked item model
         * @return the modified unbaked item model
         */
        class_10439.class_10441 modifyBeforeBake(class_2960 id, class_10439.class_10441 unbaked);
    }

    @FunctionalInterface
    public interface AddUnbaked {
        /**
         * Called to add unbaked item models to the game.
         * @param assetCollector a consumer that accepts unbaked item models or item assets with an identifier
         */
        void addUnbakedModels(ItemAssetCollector assetCollector);
    }

}
