package com.eightsidedsquare.zine.client.model;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_10411;
import net.minecraft.class_2960;
import net.minecraft.class_4944;
import java.util.function.BiConsumer;

@Environment(EnvType.CLIENT)
public final class ModelEvents {
    private ModelEvents() {
    }

    /**
     * Event to dynamically add unbaked models to the game, in a similar manner to data generation.
     */
    public static final Event<AddUnbaked> ADD_UNBAKED = EventFactory.createArrayBacked(AddUnbaked.class, callbacks -> modelCollector -> {
        for(AddUnbaked callback : callbacks) {
            callback.addUnbakedModels(modelCollector);
        }
    });

    @FunctionalInterface
    public interface AddUnbaked {
        /**
         * Called to add unbaked json models to the game.
         * @see net.minecraft.class_4942#method_25852(class_2960, class_4944, BiConsumer)
         * @param modelCollector a consumer that accepts the id of a model and a supplier for it in JSON form
         */
        void addUnbakedModels(BiConsumer<class_2960, class_10411> modelCollector);
    }

}
