package com.eightsidedsquare.zine.client.trim;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10186;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_8051;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import java.util.Arrays;
import java.util.Map;

/**
 * Offers a method of adding armor trim materials and patterns in a (theoretically) mod-compatible manner.
 * <p>These methods do not register {@link class_8054 armor trim materials} or {@link class_8056 armor trim patterns}.
 * They must still be registered through JSON or {@link net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider data generation}.
 * <p>This API has trouble with the following cases:
 * <ul>
 *     <li>The trim item overlay may apply strangely to armor item models that do not match the form of vanilla's armor item models.
 *     Use {@link #excludeForItemModelModification(class_1792...)} or {@link #excludeForItemModelModification(class_2960...)}
 *     to exclude items.
 *     <li>The trim item overlay will not be applied to non-armor item models.
 *     <li>The trim item overlay will not be applied to armor item models that don't use
 *     {@link net.minecraft.class_10451 minecraft:select} as their model type.
 *     <li>Custom equipment renderer implementations that don't handle trims with {@code EquipmentRenderer$TrimSpriteKey}
 *     (private class) will use a missing texture for non-vanilla materials.
 * </ul>
 */
@Environment(EnvType.CLIENT)
public final class ArmorTrimRegistry {
    private ArmorTrimRegistry() {
    }

    /**
     * Registers a material.
     * @param key the registry key of the armor trim material
     * @param name the name of the material, used for texture permutations
     * @param colorPaletteTexture the resource location of the color palette texture.
     *                            Usually, this value is {@code <namespace>:trims/color_palettes/<name>}
     * @param equipmentItemModelIds a map that supplies the item texture given an equipment type
     */
    public static void registerMaterial(class_5321<class_8054> key, String name, class_2960 colorPaletteTexture, Map<class_8051, class_2960> equipmentItemModelIds) {
        ArmorTrimRegistryImpl.registerMaterial(key, name, colorPaletteTexture, equipmentItemModelIds);
    }

    /**
     * Registers a material with standard naming schemes.
     * @param key the registry key of the armor trim material
     */
    public static void registerMaterial(class_5321<class_8054> key) {
        ArmorTrimRegistryImpl.registerMaterial(key);
    }

    /**
     * Registers a pattern.
     * @param key the registry key of the armor trim pattern
     * @param equipmentTextures a map that supplies the equipment texture given an equipment type
     */
    public void registerPattern(class_5321<class_8056> key, Map<class_10186.class_10190, class_2960> equipmentTextures) {
        ArmorTrimRegistryImpl.registerPattern(key, equipmentTextures);
    }

    /**
     * Registers a pattern with standard naming schemes.
     * @param key the registry key of the armor trim pattern
     */
    public static void registerPattern(class_5321<class_8056> key) {
        ArmorTrimRegistryImpl.registerPattern(key);
    }

    /**
     * @param ids identifiers of item models that should be excluded for item model modification,
     *            in which the trim overlay is added
     */
    public static void excludeForItemModelModification(class_2960... ids) {
        ArmorTrimRegistryImpl.excludeForItemModelModification(ids);
    }

    /**
     * @param items items that should be excluded for item model modification,
     *            in which the trim overlay is added
     */
    public static void excludeForItemModelModification(class_1792... items) {
        ArmorTrimRegistryImpl.excludeForItemModelModification(Arrays.stream(items).map(class_7923.field_41178::method_10221).toArray(class_2960[]::new));
    }

}
