package com.eightsidedsquare.zine.common.entity.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1309;
import net.minecraft.class_4118;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_7893;

public final class RandomTaskBuilderImpl<E extends class_1309> implements RandomTaskBuilder<E> {

    private final ImmutableMap.Builder<class_4140<?>, class_4141> requiredMemoryStates = ImmutableMap.builder();
    private final ImmutableList.Builder<Pair<? extends class_7893<? super E>, Integer>> tasks = ImmutableList.builder();

    @Override
    public class_4118<E> build() {
        return new class_4118<>(this.requiredMemoryStates.build(), this.tasks.build());
    }

    @Override
    public RandomTaskBuilder<E> memory(class_4140<?> memoryModuleType, class_4141 state) {
        this.requiredMemoryStates.put(memoryModuleType, state);
        return this;
    }

    @Override
    public RandomTaskBuilder<E> task(class_7893<? super E> task) {
        return this.task(task, 1);
    }

    @Override
    public RandomTaskBuilder<E> task(class_7893<? super E> task, int weight) {
        this.tasks.add(new Pair<>(task, weight));
        return this;
    }
}
