package com.eightsidedsquare.zine.common.entity.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4168;
import net.minecraft.class_7893;

public final class TaskListBuilderImpl<E extends class_1309> implements TaskListBuilder<E> {

    private final class_4095<E> brain;
    private final class_4168 activity;
    private final ImmutableList.Builder<Pair<Integer, ? extends class_7893<? super E>>> indexedTasks = ImmutableList.builder();
    private final ImmutableSet.Builder<Pair<class_4140<?>, class_4141>> requiredMemories = ImmutableSet.builder();
    private final Set<class_4140<?>> forgettingMemories = Sets.newHashSet();
    private int priority;

    public TaskListBuilderImpl(class_4095<E> brain, class_4168 activity, int priority) {
        this.brain = brain;
        this.activity = activity;
        this.priority = priority;
    }

    public TaskListBuilderImpl(class_4095<E> brain, class_4168 activity) {
        this(brain, activity, 0);
    }

    @Override
    public void build() {
        this.brain.method_24530(this.activity, this.indexedTasks.build(), this.requiredMemories.build(), this.forgettingMemories);
    }

    @Override
    public TaskListBuilder<E> task(class_7893<? super E> task) {
        return this.task(task, this.priority);
    }

    @Override
    public TaskListBuilder<E> task(class_7893<? super E> task, int priority) {
        this.indexedTasks.add(new Pair<>(priority, task));
        this.priority = priority + 1;
        return this;
    }

    @Override
    public TaskListBuilder<E> memory(class_4140<?> memoryModuleType, class_4141 state) {
        this.requiredMemories.add(new Pair<>(memoryModuleType, state));
        return this;
    }

    @Override
    public TaskListBuilder<E> forgetMemory(class_4140<?> memoryModuleType) {
        this.forgettingMemories.add(memoryModuleType);
        return this;
    }

    @Override
    public TaskListBuilder<E> forgetMemories(Collection<class_4140<?>> memoryModuleTypes) {
        this.forgettingMemories.addAll(memoryModuleTypes);
        return this;
    }
}
