package com.eightsidedsquare.zine.common.registry;

import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_2378;
import net.minecraft.class_5321;

public final class FreezeRegistriesEvents {

    public static <T> Event<Callback<T>> beforeFreeze(class_5321<? extends class_2378<T>> registryKey) {
        return FreezeRegistriesEventsImpl.getOrCreateEvent(true, registryKey);
    }

    public static <T> Event<Callback<T>> beforeFreeze(class_2378<T> registry) {
        return beforeFreeze(registry.method_46765());
    }

    public static <T> Event<Callback<T>> afterFreeze(class_5321<? extends class_2378<T>> registryKey) {
        return FreezeRegistriesEventsImpl.getOrCreateEvent(false, registryKey);
    }

    public static <T> Event<Callback<T>> afterFreeze(class_2378<T> registry) {
        return afterFreeze(registry.method_46765());
    }

    @FunctionalInterface
    public interface Callback<T> {

        void onFreeze(class_2378<T> registry);

    }

    private FreezeRegistriesEvents() {
    }

}
