package com.eightsidedsquare.zine.common.registry;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import java.util.Map;

@SuppressWarnings("unchecked")
public final class FreezeRegistriesEventsImpl {

    private static final Map<class_5321<? extends class_2378<?>>, Event<FreezeRegistriesEvents.Callback<?>>> BEFORE = new Object2ObjectOpenHashMap<>();
    private static final Map<class_5321<? extends class_2378<?>>, Event<FreezeRegistriesEvents.Callback<?>>> AFTER = new Object2ObjectOpenHashMap<>();

    public static <T> Event<FreezeRegistriesEvents.Callback<T>> getOrCreateEvent(boolean before, class_5321<? extends class_2378<T>> registryKey) {
        return (Event<FreezeRegistriesEvents.Callback<T>>) (Object) (before ? BEFORE : AFTER)
                .computeIfAbsent(registryKey, key -> createEvent());
    }

    private static <T> Event<FreezeRegistriesEvents.Callback<?>> createEvent() {
        return EventFactory.createArrayBacked(
                FreezeRegistriesEvents.Callback.class,
                callbacks -> registry -> {
                    for (FreezeRegistriesEvents.Callback<?> callback : callbacks) {
                        ((FreezeRegistriesEvents.Callback<T>) callback).onFreeze((class_2378<T>) registry);
                    }
                }
        );
    }

    public static <T> void apply(boolean before, class_2378<T> registry) {
        Event<FreezeRegistriesEvents.Callback<T>> callback = (Event<FreezeRegistriesEvents.Callback<T>>) (Object)
                (before ? BEFORE : AFTER).get(registry.method_46765());
        if(callback != null) {
            callback.invoker().onFreeze(registry);
        }
    }

    private FreezeRegistriesEventsImpl() {
    }
}
