package com.eightsidedsquare.zine.common.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_8051;

public final class ZineUtil {
    private ZineUtil() {
    }

    public static final class_8051[] HUMANOID_EQUIPMENT_TYPES = new class_8051[]{
            class_8051.field_41934,
            class_8051.field_41935,
            class_8051.field_41936,
            class_8051.field_41937
    };

    public static <T> List<T> addOrUnfreeze(List<T> list, T value) {
        try {
            list.add(value);
        } catch (UnsupportedOperationException e) {
            list = new ObjectArrayList<>(list);
            list.add(value);
        }
        return list;
    }

    public static <T> List<T> addAllOrUnfreeze(List<T> list, Collection<T> values) {
        try {
            list.addAll(values);
        } catch (UnsupportedOperationException e) {
            list = new ObjectArrayList<>(list);
            list.addAll(values);
        }
        return list;
    }

    public static <T> List<T> setOrUnfreeze(List<T> list, int index, T value) {
        try {
            list.set(index, value);
        } catch (UnsupportedOperationException e) {
            list = new ObjectArrayList<>(list);
            list.set(index, value);
        }
        return list;
    }

    public static <K, V> Map<K, V> putOrUnfreeze(Map<K, V> map, K key, V value) {
        try {
            map.put(key, value);
        } catch (UnsupportedOperationException e) {
            map = new Object2ObjectOpenHashMap<>(map);
            map.put(key, value);
        }
        return map;
    }

    public static <E, T> class_6885<T> mergeValue(class_6885<T> registryEntryList, Function<E, class_6880<T>> mapper, E value) {
        if(registryEntryList.method_40247() == 0) {
            return class_6885.method_40245(mapper, value);
        }
        List<class_6880<T>> list = new ObjectArrayList<>(registryEntryList.iterator());
        list.add(mapper.apply(value));
        return class_6885.method_40242(list);
    }

    public static <E, T> class_6885<T> mergeValues(class_6885<T> registryEntryList, Function<E, class_6880<T>> mapper, Collection<E> values) {
        if(registryEntryList.method_40247() == 0) {
            return class_6885.method_40244(mapper, values);
        }
        List<class_6880<T>> list = new ObjectArrayList<>(registryEntryList.iterator());
        values.forEach(value -> list.add(mapper.apply(value)));
        return class_6885.method_40242(list);
    }

    public static <T> class_6885<T> mergeValues(class_6885<T> first, class_6885<T> second) {
        if(first.method_40247() == 0) {
            return second;
        }else if(second.method_40247() == 0) {
            return first;
        }
        List<class_6880<T>> list = new ObjectArrayList<>(first.iterator());
        second.forEach(list::add);
        return class_6885.method_40242(list);
    }

}
