package com.eightsidedsquare.zine.common.util.codec;

import com.mojang.serialization.Codec;
import net.minecraft.class_2378;
import net.minecraft.class_2941;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

/**
 * <p>A RegistryCodecGroup holds codecs and packet codecs which can be useful when working with a dynamic registry.
 * <p>The Tracked subtype registers a tracked data handler for a registry entry.
 */
public interface RegistryCodecGroup<T> {

    static <T> RegistryCodecGroup<T> create(class_5321<class_2378<T>> registryKey, Codec<T> codec, Codec<T> networkCodec) {
        return new RegistryCodecGroupImpl<>(registryKey, codec, networkCodec);
    }

    static <T> RegistryCodecGroup<T> create(class_5321<class_2378<T>> registryKey, Codec<T> codec) {
        return new RegistryCodecGroupImpl<>(registryKey, codec, codec);
    }

    static <T> RegistryCodecGroup.Tracked<T> createTracked(class_5321<class_2378<T>> registryKey, Codec<T> codec, Codec<T> networkCodec) {
        return new RegistryCodecGroupImpl.TrackedImpl<>(registryKey, codec, networkCodec);
    }

    static <T> RegistryCodecGroup.Tracked<T> createTracked(class_5321<class_2378<T>> registryKey, Codec<T> codec) {
        return new RegistryCodecGroupImpl.TrackedImpl<>(registryKey, codec, codec);
    }

    class_5321<class_2378<T>> registryKey();

    Codec<T> codec();

    Codec<T> networkCodec();

    Codec<class_6880<T>> entryCodec();

    class_9139<class_9129, class_6880<T>> packetCodec();

    interface Tracked<T> extends RegistryCodecGroup<T> {

        class_2941<class_6880<T>> trackedDataHandler();

    }

}
