package com.eightsidedsquare.zine.common.util.shape;

import com.eightsidedsquare.zine.common.state.StateMap;
import com.eightsidedsquare.zine.common.state.StateMapBuilder;
import net.minecraft.class_10821;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_4990;

public final class VoxelShapeUtil {
    private VoxelShapeUtil() {
    }

    public static final class_265 EMPTY = class_259.method_1073();

    /**
     * Creates the state map for {@link net.minecraft.class_2544} properties with the voxel shapes combined for each permutation.
     * @param upShape the voxel shape of the center column
     * @param lowShape the voxel shape of the connecting north side when low
     * @param tallShape the voxel shape of the connecting north side when tall
     */
    public static StateMap<class_265> createWallMap(class_265 upShape, class_265 lowShape, class_265 tallShape) {
        return createWallLikeMap(class_2741.field_12519, upShape, lowShape, tallShape);
    }

    /**
     * Creates the state map for {@link net.minecraft.class_10322} properties with the voxel shapes combined for each permutation.
     * @param bottomShape the voxel shape of the bottom carpet
     * @param lowShape the voxel shape of the connecting north side when low
     * @param tallShape the voxel shape of the connecting north side when tall
     */
    public static StateMap<class_265> createMossyCarpetMap(class_265 bottomShape, class_265 lowShape, class_265 tallShape) {
        return createWallLikeMap(class_2741.field_16562, bottomShape, lowShape, tallShape);
    }

    /**
     * Creates the state map for {@link net.minecraft.class_2310} properties with the voxel shapes combined for each permutation.
     * @param centerShape the voxel shape at the center of each shape
     * @param sideShape the voxel shape of the connecting side facing north
     */
    public static StateMap<class_265> createHorizontalConnectingMap(class_265 centerShape, class_265 sideShape) {
        class_265 eastShape = class_259.method_66496(sideShape, class_4990.method_67986(class_10821.field_57029, class_10821.field_57030));
        class_265 southShape = class_259.method_66496(sideShape, class_4990.method_67986(class_10821.field_57029, class_10821.field_57031));
        class_265 westShape = class_259.method_66496(sideShape, class_4990.method_67986(class_10821.field_57029, class_10821.field_57032));
        return StateMapBuilder.create(
                class_2741.field_12489,
                class_2741.field_12487,
                class_2741.field_12540,
                class_2741.field_12527,
                (north, east, south, west) -> class_259.method_17786(
                        centerShape,
                        north ? sideShape : EMPTY,
                        east ? eastShape : EMPTY,
                        south ? southShape : EMPTY,
                        west ? westShape : EMPTY
                )
        );
    }

    /**
     * Creates the state map for {@link net.minecraft.class_2429} or {@link net.minecraft.class_5778} properties with the voxel shapes combined for each permutation.
     * @param centerShape the voxel shape at the center of each shape
     * @param sideShape the voxel shape of the connecting side facing north
     */
    public static StateMap<class_265> createConnectingMap(class_265 centerShape, class_265 sideShape) {
        class_265 eastShape = class_259.method_66496(sideShape, class_4990.method_67986(class_10821.field_57029, class_10821.field_57030));
        class_265 southShape = class_259.method_66496(sideShape, class_4990.method_67986(class_10821.field_57029, class_10821.field_57031));
        class_265 westShape = class_259.method_66496(sideShape, class_4990.method_67986(class_10821.field_57029, class_10821.field_57032));
        class_265 upShape = class_259.method_66496(sideShape, class_4990.method_67986(class_10821.field_57032, class_10821.field_57029));
        class_265 downShape = class_259.method_66496(sideShape, class_4990.method_67986(class_10821.field_57030, class_10821.field_57029));
        return StateMapBuilder.create(
                class_2741.field_12489,
                class_2741.field_12487,
                class_2741.field_12540,
                class_2741.field_12527,
                class_2741.field_12519,
                class_2741.field_12546,
                (north, east, south, west, up, down) -> class_259.method_17786(
                        centerShape,
                        north ? sideShape : EMPTY,
                        east ? eastShape : EMPTY,
                        south ? southShape : EMPTY,
                        west ? westShape : EMPTY,
                        up ? upShape : EMPTY,
                        down ? downShape : EMPTY
                )
        );
    }

    private static StateMap<class_265> createWallLikeMap(class_2746 centerProperty, class_265 centerShape, class_265 lowShape, class_265 tallShape) {
        class_265[] northShapes = {EMPTY, lowShape, tallShape};
        class_265[] eastShapes = {
                EMPTY,
                class_259.method_66496(lowShape, class_4990.method_67986(class_10821.field_57029, class_10821.field_57030)),
                class_259.method_66496(tallShape, class_4990.method_67986(class_10821.field_57029, class_10821.field_57030))
        };
        class_265[] southShapes = {
                EMPTY,
                class_259.method_66496(lowShape, class_4990.method_67986(class_10821.field_57029, class_10821.field_57031)),
                class_259.method_66496(tallShape, class_4990.method_67986(class_10821.field_57029, class_10821.field_57031))
        };
        class_265[] westShapes = {
                EMPTY,
                class_259.method_66496(lowShape, class_4990.method_67986(class_10821.field_57029, class_10821.field_57032)),
                class_259.method_66496(tallShape, class_4990.method_67986(class_10821.field_57029, class_10821.field_57032))
        };
        return StateMapBuilder.create(
                centerProperty,
                class_2741.field_22175,
                class_2741.field_22174,
                class_2741.field_22176,
                class_2741.field_22177,
                (center, north, east, south, west) -> class_259.method_17786(
                        center ? centerShape : EMPTY,
                        northShapes[north.ordinal()],
                        eastShapes[east.ordinal()],
                        southShapes[south.ordinal()],
                        westShapes[west.ordinal()]
                )
        );
    }

}
