package com.eightsidedsquare.zine.common.world.structure;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_6880;

public interface ZineStructurePool {

    default ObjectArrayList<class_3784> zine$getElements() {
        throw new UnsupportedOperationException("Implemented via mixin.");
    }

    default List<Pair<class_3784, Integer>> zine$getElementWeights() {
        throw new UnsupportedOperationException("Implemented via mixin.");
    }

    default void zine$addElement(class_3784 element, int weight) {
        throw new UnsupportedOperationException("Implemented via mixin.");
    }

    default void zine$addElement(
            Function<class_3785.class_3786, ? extends class_3784> elementGetter,
            int weight,
            class_3785.class_3786 projection) {
        this.zine$addElement(elementGetter.apply(projection), weight);
    }

    default void zine$setFallback(class_6880<class_3785> fallback) {
        throw new UnsupportedOperationException("Implemented via mixin.");
    }

}
