package com.eightsidedsquare.zine.data.particle;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

/**
 * Extend this class and implement {@link ParticleTextureDataProvider#generate}.
 *
 * <p>Register an instance of the class with {@link FabricDataGenerator.Pack#addProvider} in a {@link net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint}.
 */
public abstract class ParticleTextureDataProvider implements class_2405 {

    private final class_7784.class_7489 pathResolver;

    public ParticleTextureDataProvider(FabricDataOutput output) {
        this.pathResolver = output.method_45973(class_7784.class_7490.field_39368, "particles");
    }

    protected abstract void generate(ParticleTextureDataConsumer consumer);

    protected final class_2960[] rangeAscending(class_2960 texture, int minInclusive, int maxInclusive) {
        class_2960[] textures = this.createRangeArray(minInclusive, maxInclusive);
        for(int i = minInclusive; i <= maxInclusive; i++) {
            textures[i] = texture.method_48331("_" + i);
        }
        return textures;
    }

    protected final class_2960[] rangeDescending(class_2960 texture, int minInclusive, int maxInclusive) {
        class_2960[] textures = this.createRangeArray(minInclusive, maxInclusive);
        for(int i = minInclusive; i <= maxInclusive; i++) {
            textures[maxInclusive + minInclusive - i] = texture.method_48331("_" + i);
        }
        return textures;
    }

    private class_2960[] createRangeArray(int minInclusive, int maxInclusive) {
        if(minInclusive < 0 || maxInclusive < 0) {
            throw new IllegalArgumentException("Range cannot be less than 0");
        }else if(minInclusive > maxInclusive) {
            throw new IllegalArgumentException("Min cannot be greater than max");
        }
        return new class_2960[maxInclusive - minInclusive + 1];
    }

    @Override
    public CompletableFuture<?> method_10319(class_7403 writer) {
        List<CompletableFuture<?>> futures = new ArrayList<>();
        Map<class_2960, List<class_2960>> map = new Object2ObjectOpenHashMap<>();
        this.generate((particleType, textures) ->
                map.put(class_7923.field_41180.method_10221(particleType), textures)
        );
        map.forEach((id, textures) -> {
            JsonObject jsonObject = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            textures.forEach(texture -> jsonArray.add(texture.toString()));
            jsonObject.add("textures", jsonArray);
            futures.add(class_2405.method_10320(writer, jsonObject, this.pathResolver.method_44107(id)));
        });
        return CompletableFuture.allOf(futures.toArray(CompletableFuture[]::new));
    }

    @Override
    public String method_10321() {
        return "Particle Texture Data";
    }
}
