package com.eightsidedsquare.zine.data.sound;

import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_3414;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;

/**
 * Extend this class and implement {@link SoundListProvider#generate}.
 *
 * <p>Register an instance of the class with {@link FabricDataGenerator.Pack#addProvider} in a {@link net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint}.
 */
public abstract class SoundListProvider implements class_2405 {

    private final Path outputPath;

    public SoundListProvider(FabricDataOutput output) {
        this.outputPath = output.method_45972(class_7784.class_7490.field_39368).resolve(output.getModId()).resolve("sounds.json");
    }

    protected abstract void generate(SoundEntryConsumer consumer);

    protected void putSubtitle(class_3414 soundEvent, String subtitle) {

    }

    @Override
    public CompletableFuture<?> method_10319(class_7403 writer) {
        JsonObject jsonObject = new JsonObject();
        this.generate((soundEvent, soundEntry) -> {
            if(soundEntry.subtitle() != null) {
                this.putSubtitle(soundEvent, soundEntry.subtitle());
            }
            SoundEntryRecord.CODEC.encodeStart(JsonOps.INSTANCE, soundEntry)
                    .ifSuccess(soundEntryJson -> jsonObject.add(soundEvent.comp_3319().method_12832(), soundEntryJson));
        });
        return class_2405.method_10320(writer, jsonObject, this.outputPath);
    }

    @Override
    public String method_10321() {
        return "Sound List";
    }
}
