package com.eightsidedsquare.zine.mixin;

import com.eightsidedsquare.zine.common.util.ZineComponentMapBuilder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9336;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_9323.class_9324.class)
public abstract class ComponentMapBuilderMixin implements ZineComponentMapBuilder {

    @Shadow public abstract <T> class_9323.class_9324 add(class_9331<T> type, @Nullable T value);

    @Shadow @Final public Reference2ObjectMap<class_9331<?>, Object> components;

    @SuppressWarnings("unchecked")
    @Override
    public <T> @Nullable T zine$get(class_9331<T> type) {
        return (T) this.components.get(type);
    }

    @Override
    public <T> class_9323.class_9324 zine$add(class_9336<T> component) {
        return this.add(component.comp_2443(), component.comp_2444());
    }

    @Override
    public <T> class_9323.class_9324 zine$remove(class_9331<T> type) {
        this.components.remove(type);
        return (class_9323.class_9324) (Object) this;
    }
}
