package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZineBredAnimalsCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_196;
import net.minecraft.class_5258;

@Mixin(class_196.class_198.class)
public abstract class BredAnimalsCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineBredAnimalsCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private Optional<class_5258> parent;

    @Shadow @Final @Mutable
    private Optional<class_5258> partner;

    @Shadow @Final @Mutable
    private Optional<class_5258> child;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setParent(@Nullable class_5258 parent) {
        this.parent = Optional.ofNullable(parent);
    }

    @Override
    public void zine$setPartner(@Nullable class_5258 partner) {
        this.partner = Optional.ofNullable(partner);
    }

    @Override
    public void zine$setChild(@Nullable class_5258 child) {
        this.child = Optional.ofNullable(child);
    }

}
