package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZineBrewedPotionCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_1842;
import net.minecraft.class_1996;
import net.minecraft.class_5258;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@Mixin(class_1996.class_1998.class)
public abstract class BrewedPotionCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineBrewedPotionCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private Optional<class_6880<class_1842>> potion;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setPotion(@Nullable class_6880<class_1842> potion) {
        this.potion = Optional.ofNullable(potion);
    }

    @Override
    public void zine$setPotion(@Nullable class_1842 potion) {
        this.potion = Optional.ofNullable(potion == null ? null : class_7923.field_41179.method_47983(potion));
    }
}
