package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZineVictimsCriterionConditions;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2002;
import net.minecraft.class_5258;

@Mixin(class_2002.class_2004.class)
public abstract class ChanneledLightningCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineVictimsCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private List<class_5258> victims;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setVictims(List<class_5258> victims) {
        this.victims = victims;
    }

    @Override
    public void zine$addVictim(class_5258 victim) {
        this.victims = ZineUtil.addOrUnfreeze(this.victims, victim);
    }

    @Override
    public void zine$addVictims(Collection<class_5258> victims) {
        this.victims = ZineUtil.addAllOrUnfreeze(this.victims, victims);
    }
}
