package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZineCuredZombieVillagerCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZineVillagerCriterionConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2014;
import net.minecraft.class_5258;

@Mixin(class_2014.class_2016.class)
public abstract class CuredZombieVillagerCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineVillagerCriterionConditions,
        ZineCuredZombieVillagerCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private Optional<class_5258> villager;

    @Shadow @Final @Mutable
    private Optional<class_5258> zombie;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setVillager(@Nullable class_5258 villager) {
        this.villager = Optional.ofNullable(villager);
    }

    @Override
    public void zine$setZombie(@Nullable class_5258 zombie) {
        this.zombie = Optional.ofNullable(zombie);
    }
}
