package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZineBlockCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZineStateCriterionConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2037;
import net.minecraft.class_2248;
import net.minecraft.class_4559;
import net.minecraft.class_5258;
import net.minecraft.class_6880;

@Mixin(class_2037.class_2039.class)
public abstract class EnterBlockCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineBlockCriterionConditions,
        ZineStateCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private Optional<class_6880<class_2248>> block;

    @Shadow @Final @Mutable
    private Optional<class_4559> state;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setBlock(@Nullable class_6880<class_2248> block) {
        this.block = Optional.ofNullable(block);
    }

    @Override
    public void zine$setState(@Nullable class_4559 state) {
        this.state = Optional.ofNullable(state);
    }
}
