package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZineLightningStrikeCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_5258;
import net.minecraft.class_6405;

@Mixin(class_6405.class_6406.class)
public abstract class LightningStrikeCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineLightningStrikeCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private Optional<class_5258> lightning;

    @Shadow @Final @Mutable
    private Optional<class_5258> bystander;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setLightning(@Nullable class_5258 lightning) {
        this.lightning = Optional.ofNullable(lightning);
    }

    @Override
    public void zine$setBystander(@Nullable class_5258 bystander) {
        this.bystander = Optional.ofNullable(bystander);
    }
}
