package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZineTargetHitCriterionConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2096;
import net.minecraft.class_4851;
import net.minecraft.class_5258;

@Mixin(class_4851.class_4852.class)
public abstract class TargetHitCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineTargetHitCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private class_2096.class_2100 signalStrength;

    @Shadow @Final @Mutable
    private Optional<class_5258> projectile;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setSignalStrength(class_2096.class_2100 signalStrength) {
        this.signalStrength = signalStrength;
    }

    @Override
    public void zine$setProjectile(@Nullable class_5258 projectile) {
        this.projectile = Optional.ofNullable(projectile);
    }
}
