package com.eightsidedsquare.zine.mixin.advancement.criterion;

import com.eightsidedsquare.zine.common.criterion.ZineItemCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZinePlayerCriterionConditions;
import com.eightsidedsquare.zine.common.criterion.ZineVillagerCriterionConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2073;
import net.minecraft.class_2140;
import net.minecraft.class_5258;

@Mixin(class_2140.class_2142.class)
public abstract class VillagerTradeCriterionConditionsMixin implements ZinePlayerCriterionConditions,
        ZineVillagerCriterionConditions,
        ZineItemCriterionConditions {

    @Shadow @Final @Mutable
    private Optional<class_5258> player;

    @Shadow @Final @Mutable
    private Optional<class_5258> villager;

    @Shadow @Final @Mutable
    private Optional<class_2073> item;

    @Override
    public void zine$setPlayer(@Nullable class_5258 player) {
        this.player = Optional.ofNullable(player);
    }

    @Override
    public void zine$setVillager(@Nullable class_5258 villager) {
        this.villager = Optional.ofNullable(villager);
    }

    @Override
    public void zine$setItem(@Nullable class_2073 item) {
        this.item = Optional.ofNullable(item);
    }
}
