package com.eightsidedsquare.zine.mixin.client.texture;

import com.eightsidedsquare.zine.client.atlas.ZinePalettedPermutationsAtlasSource;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;

import java.util.*;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_8066;

@Mixin(class_8066.class)
public abstract class PalettedPermutationsAtlasSourceMixin implements ZinePalettedPermutationsAtlasSource {

    @Shadow @Final @Mutable
    private List<class_2960> textures;
    @Shadow @Final @Mutable
    private Map<String, class_2960> permutations;
    @Shadow @Final @Mutable
    private class_2960 paletteKey;
    @Unique
    private final Set<String> namespacedPermutations = new HashSet<>();

    @Override
    public void zine$addPermutation(String name, class_2960 texture) {
        try {
            this.permutations.put(name, texture);
        } catch (UnsupportedOperationException e) {
            this.permutations = new Object2ObjectOpenHashMap<>(this.permutations);
            this.permutations.put(name, texture);
        }
    }

    @Override
    public void zine$addNamespacedPermutation(String name, class_2960 texture) {
        this.namespacedPermutations.add(name);
        this.zine$addPermutation(name, texture);
    }

    @Override
    public void zine$addTexture(class_2960 texture) {
        try {
            this.textures.add(texture);
        } catch (UnsupportedOperationException e) {
            this.textures = new ArrayList<>(this.textures);
            this.textures.add(texture);
        }
    }

    @Override
    public class_2960 zine$getPaletteKey() {
        return this.paletteKey;
    }

    @Override
    public void zine$setPaletteKey(class_2960 paletteKey) {
        this.paletteKey = paletteKey;
    }

    @ModifyExpressionValue(method = "load", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/Identifier;withSuffixedPath(Ljava/lang/String;)Lnet/minecraft/util/Identifier;"))
    private class_2960 zine$swapPermutationNamespace(class_2960 original, @Local Map.Entry<String, Supplier<IntUnaryOperator>> entry) {
        String permutation = entry.getKey();
        if(this.namespacedPermutations.contains(permutation)) {
            return class_2960.method_60655(this.permutations.get(permutation).method_12836(), original.method_12832());
        }
        return original;
    }
}
