package com.eightsidedsquare.zine.mixin.entity.spawn;

import com.eightsidedsquare.zine.common.entity.spawn.ZineStructureSpawnCondition;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Collection;
import java.util.function.Function;
import net.minecraft.class_10703;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7871;

@Mixin(class_10703.class)
public abstract class StructureSpawnConditionMixin implements ZineStructureSpawnCondition {

    @Shadow @Final @Mutable
    private class_6885<class_3195> requiredStructures;

    @Override
    public void zine$setRequiredStructures(class_6885<class_3195> requiredStructures) {
        this.requiredStructures = requiredStructures;
    }

    @Override
    public void zine$addRequiredStructure(class_6880<class_3195> requiredStructure) {
        this.requiredStructures = ZineUtil.mergeValue(this.requiredStructures, Function.identity(), requiredStructure);
    }

    @Override
    public void zine$addRequiredStructure(class_7871<class_3195> structureLookup, class_5321<class_3195> requiredStructure) {
        this.requiredStructures = ZineUtil.mergeValue(this.requiredStructures, structureLookup::method_46747, requiredStructure);
    }

    @Override
    public void zine$addRequiredStructures(class_7871<class_3195> structureLookup, Collection<class_5321<class_3195>> requiredStructures) {
        this.requiredStructures = ZineUtil.mergeValues(this.requiredStructures, structureLookup::method_46747, requiredStructures);
    }

    @Override
    public void zine$addRequiredStructures(class_6885<class_3195> requiredStructures) {
        this.requiredStructures = ZineUtil.mergeValues(this.requiredStructures, requiredStructures);
    }
}
