package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineComponentMapPredicate;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import net.minecraft.class_9329;
import net.minecraft.class_9336;

@Mixin(class_9329.class)
public abstract class ComponentMapPredicateMixin implements ZineComponentMapPredicate {

    @Shadow @Final @Mutable
    private List<class_9336<?>> components;

    @Override
    public void zine$setComponents(List<class_9336<?>> components) {
        this.components = components;
    }

    @Override
    public void zine$addComponent(class_9336<?> component) {
        this.components = ZineUtil.addOrUnfreeze(this.components, component);
    }

    @Override
    public void zine$addComponents(List<class_9336<?>> components) {
        this.components = ZineUtil.addAllOrUnfreeze(this.components, components);
    }
}
