package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineDamagePredicate;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2019;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_2096;

@Mixin(class_2019.class)
public abstract class DamagePredicateMixin implements ZineDamagePredicate {

    @Shadow @Final @Mutable
    private class_2096.class_2099 dealt;

    @Shadow @Final @Mutable
    private class_2096.class_2099 taken;

    @Shadow @Final @Mutable
    private Optional<class_2048> sourceEntity;

    @Shadow @Final @Mutable
    private Optional<Boolean> blocked;

    @Shadow @Final @Mutable
    private Optional<class_2022> type;

    @Override
    public void zine$setDealt(class_2096.class_2099 dealt) {
        this.dealt = dealt;
    }

    @Override
    public void zine$setTaken(class_2096.class_2099 taken) {
        this.taken = taken;
    }

    @Override
    public void zine$setSourceEntity(@Nullable class_2048 sourceEntity) {
        this.sourceEntity = Optional.ofNullable(sourceEntity);
    }

    @Override
    public void zine$setBlocked(@Nullable Boolean blocked) {
        this.blocked = Optional.ofNullable(blocked);
    }

    @Override
    public void zine$setType(@Nullable class_2022 type) {
        this.type = Optional.ofNullable(type);
    }
}
