package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineEntityEffectPredicate;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_2102;
import net.minecraft.class_6880;

@Mixin(class_2102.class)
public abstract class EntityEffectPredicateMixin implements ZineEntityEffectPredicate {

    @Shadow @Final @Mutable
    private Map<class_6880<class_1291>, class_2102.class_2103> effects;

    @Override
    public void zine$setEffects(Map<class_6880<class_1291>, class_2102.class_2103> effects) {
        this.effects = effects;
    }

    @Override
    public void zine$addEffect(class_6880<class_1291> effect, class_2102.class_2103 data) {
        this.effects = ZineUtil.putOrUnfreeze(this.effects, effect, data);
    }
}
