package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineEntityEquipmentPredicate;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2073;
import net.minecraft.class_3735;

@Mixin(class_3735.class)
public abstract class EntityEquipmentPredicateMixin implements ZineEntityEquipmentPredicate {

    @Shadow @Final @Mutable
    private Optional<class_2073> head;

    @Shadow @Final @Mutable
    private Optional<class_2073> chest;

    @Shadow @Final @Mutable
    private Optional<class_2073> legs;

    @Shadow @Final @Mutable
    private Optional<class_2073> feet;

    @Shadow @Final @Mutable
    private Optional<class_2073> body;

    @Shadow @Final @Mutable
    private Optional<class_2073> mainhand;

    @Shadow @Final @Mutable
    private Optional<class_2073> offhand;

    @Override
    public void zine$setHead(@Nullable class_2073 head) {
        this.head = Optional.ofNullable(head);
    }

    @Override
    public void zine$setChest(@Nullable class_2073 chest) {
        this.chest = Optional.ofNullable(chest);
    }

    @Override
    public void zine$setLegs(@Nullable class_2073 legs) {
        this.legs = Optional.ofNullable(legs);
    }

    @Override
    public void zine$setFeet(@Nullable class_2073 feet) {
        this.feet = Optional.ofNullable(feet);
    }

    @Override
    public void zine$setBody(@Nullable class_2073 body) {
        this.body = Optional.ofNullable(body);
    }

    @Override
    public void zine$setMainhand(@Nullable class_2073 mainhand) {
        this.mainhand = Optional.ofNullable(mainhand);
    }

    @Override
    public void zine$setOffhand(@Nullable class_2073 offhand) {
        this.offhand = Optional.ofNullable(offhand);
    }
}
