package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineEntityPredicate;
import com.eightsidedsquare.zine.common.predicate.ZineEntityPredicatePositionalPredicates;
import net.minecraft.class_10914;
import net.minecraft.class_2025;
import net.minecraft.class_2040;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_2090;
import net.minecraft.class_2102;
import net.minecraft.class_2105;
import net.minecraft.class_3735;
import net.minecraft.class_7376;
import net.minecraft.class_9350;
import net.minecraft.class_9750;
import net.minecraft.predicate.entity.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;

@Mixin(class_2048.class)
public abstract class EntityPredicateMixin implements ZineEntityPredicate, ZineEntityPredicatePositionalPredicates {

    @Shadow @Final @Mutable
    private Optional<class_2050> type;

    @Shadow @Final @Mutable
    private Optional<class_2025> distance;

    @Shadow @Final @Mutable
    private Optional<class_9750> movement;

    @Shadow @Final @Mutable
    private class_2048.class_9777 location;

    @Shadow @Final @Mutable
    private Optional<class_2102> effects;

    @Shadow @Final @Mutable
    private Optional<class_2105> nbt;

    @Shadow @Final @Mutable
    private Optional<class_2040> flags;

    @Shadow @Final @Mutable
    private Optional<class_3735> equipment;

    @Shadow @Final @Mutable
    private Optional<class_7376> typeSpecific;

    @Shadow @Final @Mutable
    private Optional<Integer> periodicTick;

    @Shadow @Final @Mutable
    private Optional<class_2048> vehicle;

    @Shadow @Final @Mutable
    private Optional<class_2048> passenger;

    @Shadow @Final @Mutable
    private Optional<class_2048> targetedEntity;

    @Shadow @Final @Mutable
    private Optional<String> team;

    @Shadow @Final @Mutable
    private Optional<class_9350> slots;

    @Shadow @Final @Mutable
    private class_10914 components;

    @Override
    public void zine$setType(@Nullable class_2050 type) {
        this.type = Optional.ofNullable(type);
    }

    @Override
    public void zine$setDistance(@Nullable class_2025 distance) {
        this.distance = Optional.ofNullable(distance);
    }

    @Override
    public void zine$setMovement(@Nullable class_9750 movement) {
        this.movement = Optional.ofNullable(movement);
    }

    @Override
    public void zine$setLocation(class_2048.class_9777 location) {
        this.location = location;
    }

    @Override
    public void zine$setEffects(@Nullable class_2102 effects) {
        this.effects = Optional.ofNullable(effects);
    }

    @Override
    public void zine$setNbt(@Nullable class_2105 nbt) {
        this.nbt = Optional.ofNullable(nbt);
    }

    @Override
    public void zine$setFlags(@Nullable class_2040 flags) {
        this.flags = Optional.ofNullable(flags);
    }

    @Override
    public void zine$setEquipment(@Nullable class_3735 equipment) {
        this.equipment = Optional.ofNullable(equipment);
    }

    @Override
    public void zine$setTypeSpecific(@Nullable class_7376 typeSpecific) {
        this.typeSpecific = Optional.ofNullable(typeSpecific);
    }

    @Override
    public void zine$setPeriodicTick(@Nullable Integer periodicTick) {
        this.periodicTick = Optional.ofNullable(periodicTick);
    }

    @Override
    public void zine$setVehicle(@Nullable class_2048 vehicle) {
        this.vehicle = Optional.ofNullable(vehicle);
    }

    @Override
    public void zine$setPassenger(@Nullable class_2048 passenger) {
        this.passenger = Optional.ofNullable(passenger);
    }

    @Override
    public void zine$setTargetedEntity(@Nullable class_2048 targetedEntity) {
        this.targetedEntity = Optional.ofNullable(targetedEntity);
    }

    @Override
    public void zine$setTeam(@Nullable String team) {
        this.team = Optional.ofNullable(team);
    }

    @Override
    public void zine$setSlots(@Nullable class_9350 slots) {
        this.slots = Optional.ofNullable(slots);
    }

    @Override
    public void zine$setComponents(class_10914 components) {
        this.components = components;
    }

    @Override
    public void zine$setLocated(@Nullable class_2090 located) {
        this.location.zine$setLocated(located);
    }

    @Override
    public void zine$setSteppingOn(@Nullable class_2090 steppingOn) {
        this.location.zine$setSteppingOn(steppingOn);
    }

    @Override
    public void zine$setAffectsMovement(@Nullable class_2090 affectsMovement) {
        this.location.zine$setAffectsMovement(affectsMovement);
    }
}
