package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineEntityPredicatePositionalPredicates;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2048;
import net.minecraft.class_2090;

@Mixin(class_2048.class_9777.class)
public abstract class EntityPredicatePositionalPredicatesMixin implements ZineEntityPredicatePositionalPredicates {

    @Shadow @Final @Mutable
    Optional<class_2090> located;

    @Shadow @Final @Mutable
    Optional<class_2090> steppingOn;

    @Shadow @Final @Mutable
    Optional<class_2090> affectsMovement;

    @Override
    public void zine$setLocated(@Nullable class_2090 located) {
        this.located = Optional.ofNullable(located);
    }

    @Override
    public void zine$setSteppingOn(@Nullable class_2090 steppingOn) {
        this.steppingOn = Optional.ofNullable(steppingOn);
    }

    @Override
    public void zine$setAffectsMovement(@Nullable class_2090 affectsMovement) {
        this.affectsMovement = Optional.ofNullable(affectsMovement);
    }
}
