package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineFluidPredicate;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_3611;
import net.minecraft.class_4551;
import net.minecraft.class_4559;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

@Mixin(class_4551.class)
public abstract class FluidPredicateMixin implements ZineFluidPredicate {

    @Shadow @Final @Mutable
    private Optional<class_6885<class_3611>> fluids;

    @Shadow @Final @Mutable
    private Optional<class_4559> state;

    @Override
    public void zine$setFluids(@Nullable class_6885<class_3611> fluids) {
        this.fluids = Optional.ofNullable(fluids);
    }

    @Override
    public void zine$addFluid(class_3611 fluid) {
        if(this.fluids.isPresent()) {
            this.fluids = Optional.of(ZineUtil.mergeValue(this.fluids.get(), class_7923.field_41173::method_47983, fluid));
            return;
        }
        this.fluids = Optional.of(class_6885.method_40245(class_7923.field_41173::method_47983, fluid));
    }

    @Override
    public void zine$addFluids(Collection<class_3611> fluids) {
        if(this.fluids.isPresent()) {
            this.fluids = Optional.of(ZineUtil.mergeValues(this.fluids.get(), class_7923.field_41173::method_47983, fluids));
            return;
        }
        this.fluids = Optional.of(class_6885.method_40244(class_7923.field_41173::method_47983, fluids));
    }

    @Override
    public void zine$setState(@Nullable class_4559 state) {
        this.state = Optional.ofNullable(state);
    }
}
